/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.appspace;

import filenet.vw.api.VWException;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWRoleDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.appspace.VWInbasketListCellRenderer;
import filenet.vw.toolkit.admin.property.appspace.VWRoleAttributesPanel;
import filenet.vw.toolkit.admin.property.appspace.VWRoleSelectBasketsDialog;
import filenet.vw.toolkit.admin.property.appspace.VWWorkBasketsTableModel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWDataDictionary;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWOpenItem;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWUsersDialog;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.images.VWToolbarButtonFocusAdapter;
import filenet.vw.toolkit.utils.table.VWDesignerParticipantListCellRenderer;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.table.VWSortedListModel;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWInfoLabel;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import filenet.vw.toolkit.utils.uicontrols.security.IVWParticipantSelectionDialog;
import filenet.vw.toolkit.utils.uicontrols.security.VWFilteredUsersAndGroupsDialog;
import filenet.vw.toolkit.utils.wfdefinition.VWDefaultSessionProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class VWRolePropertyPanel
extends JPanel
implements ActionListener,
TableModelListener,
ListDataListener,
IVWToolbarBorderActionListener,
ListSelectionListener,
DocumentListener {
    private VWSessionInfo m_sessionInfo = null;
    private VWDataDictionary m_dataDictionary = null;
    private VWRoleDefinition m_roleDef = null;
    private boolean m_bIsModified = false;
    private HashSet<String> m_modifiedQueueNames = null;
    private JLabel m_roleNameLabel = null;
    private JButton m_helpButton = null;
    private JTextArea m_descriptionTextArea = null;
    private JTextField m_homePageTextField = null;
    private JButton m_previewButton = null;
    private VWTable m_workBasketsTable = null;
    private VWWorkBasketsTableModel m_workBasketsTableModel = null;
    private VWToolbarBorder m_inbasketsToolBar = null;
    private VWToolbarBorder m_membersToolBar = null;
    private VWSortedListModel m_membersListModel = null;
    private JList m_membersList = null;
    private IVWParticipantSelectionDialog m_usersAndGroupsDialog = null;
    private VWRoleAttributesPanel m_attributesPanel = null;

    public VWRolePropertyPanel(VWSessionInfo sessionInfo, VWDataDictionary dataDictionary) {
        this.m_sessionInfo = sessionInfo;
        this.m_dataDictionary = dataDictionary;
        this.m_modifiedQueueNames = new HashSet();
        this.createControls();
        this.setEnabled(false);
    }

    public void setEnabled(boolean bEnable) {
        this.m_descriptionTextArea.setEnabled(bEnable);
        this.m_homePageTextField.setEnabled(bEnable);
        if (bEnable) {
            this.updatePreviewButtonState();
        } else {
            this.m_previewButton.setEnabled(bEnable);
        }
        int nButtonState = 2;
        int nButtons = Integer.MAX_VALUE;
        if (bEnable) {
            nButtonState = 1;
            if (this.m_membersList.getSelectedIndex() == -1) {
                nButtons = 32;
            }
        }
        this.m_inbasketsToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_inbasketsToolBar.getClientPanel(), nButtonState, nButtons));
        this.m_workBasketsTable.setEnabled(bEnable);
        this.m_membersToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_membersToolBar.getClientPanel(), nButtonState, nButtons));
        this.m_membersList.setEnabled(bEnable);
        this.m_attributesPanel.setEnabled(bEnable);
    }

    public void checkForErrors() throws Exception {
        if (this.m_attributesPanel != null) {
            this.m_attributesPanel.checkForErrors();
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            this.stopEditing();
            if (event.getSource().equals(this.m_helpButton)) {
                VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc085.htm");
            } else if (event.getSource().equals(this.m_previewButton)) {
                VWOpenItem openItem;
                String urlValue = null;
                if (this.m_homePageTextField.getText() != null && this.m_homePageTextField.getText().length() > 0) {
                    urlValue = this.m_homePageTextField.getText();
                }
                if (urlValue != null && urlValue.length() > 0 && (openItem = new VWOpenItem(this.m_sessionInfo)) != null) {
                    openItem.displayURL(urlValue);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            this.stopEditing();
            if (event.getSource().equals(this.m_inbasketsToolBar)) {
                switch (event.getID()) {
                    case 32: {
                        this.modifyInbasketList();
                        break;
                    }
                    case 0x10000000: {
                        this.deleteSelectedInbaskets();
                        break;
                    }
                    case 1: {
                        this.moveUpSelectedInbaskets();
                        break;
                    }
                    case 2: {
                        this.moveDownSelectedInbaskets();
                    }
                }
            } else if (event.getSource().equals(this.m_membersToolBar)) {
                switch (event.getID()) {
                    case 32: {
                        this.modifyMembersList();
                        break;
                    }
                    case 0x10000000: {
                        this.deleteSelectedMembers();
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow();
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow > this.m_workBasketsTable.getRowCount() - 1) {
                    nRow = this.m_workBasketsTable.getRowCount() - 1;
                }
                if (nRow == -1) {
                    return;
                }
                if (nRow == this.m_workBasketsTable.getSelectedRow()) {
                    this.m_workBasketsTable.clearSelection();
                }
                this.m_workBasketsTable.setRowSelectionInterval(nRow, nRow);
                break;
            }
        }
    }

    public void contentsChanged(ListDataEvent e) {
    }

    public void intervalAdded(ListDataEvent e) {
    }

    public void intervalRemoved(ListDataEvent e) {
        int idx = e.getIndex0();
        if (idx < 0) {
            idx = 0;
        }
        if (idx > this.m_membersListModel.size() - 1) {
            idx = this.m_membersListModel.size() - 1;
        }
        if (idx == -1) {
            return;
        }
        if (idx == this.m_membersList.getSelectedIndex()) {
            this.m_membersList.clearSelection();
        }
        this.m_membersList.setSelectedIndex(idx);
        this.m_membersList.updateUI();
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getSource().equals(this.m_workBasketsTable.getSelectionModel())) {
            this.updateInbasketListButtonStates();
        } else if (this.m_membersList != null && event.getSource().equals(this.m_membersList)) {
            this.updateMembersListButtonStates();
        }
    }

    public void changedUpdate(DocumentEvent event) {
        this.handleUpdateEvent(event.getDocument());
    }

    public void insertUpdate(DocumentEvent event) {
        this.changedUpdate(event);
    }

    public void removeUpdate(DocumentEvent event) {
        this.changedUpdate(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRoleDefinition(VWRoleDefinition roleDefinition) {
        try {
            block7: {
                try {
                    this.m_roleDef = roleDefinition;
                    this.setEnabled(this.m_roleDef != null);
                    this.m_homePageTextField.getDocument().removeDocumentListener(this);
                    this.m_descriptionTextArea.getDocument().removeDocumentListener(this);
                    if (this.m_roleDef != null) {
                        this.m_roleNameLabel.setText(this.m_roleDef.getName());
                        VWAccessibilityHelper.setAccessibility(this.m_roleNameLabel, this, this.m_roleNameLabel.getText(), this.m_roleNameLabel.getText());
                        this.m_descriptionTextArea.setText(this.m_roleDef.getDescription());
                        this.m_descriptionTextArea.setCaretPosition(0);
                        this.m_homePageTextField.setText(this.m_roleDef.getHomePageURL());
                    } else {
                        this.m_roleNameLabel.setText(VWResource.NoRoleSelected);
                        VWAccessibilityHelper.setAccessibility(this.m_roleNameLabel, this, this.m_roleNameLabel.getText(), this.m_roleNameLabel.getText());
                        this.m_descriptionTextArea.setText(null);
                        this.m_homePageTextField.setText(null);
                    }
                    this.updatePreviewButtonState();
                    if (this.m_workBasketsTableModel != null) {
                        this.m_workBasketsTableModel.setRoleDefinition(roleDefinition);
                    }
                    this.initMembersList();
                    if (this.m_attributesPanel == null) break block7;
                    this.m_attributesPanel.setRoleDefinition(roleDefinition);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    Object var4_3 = null;
                    this.m_homePageTextField.getDocument().addDocumentListener(this);
                    this.m_descriptionTextArea.getDocument().addDocumentListener(this);
                    this.m_bIsModified = false;
                }
            }
            Object var4_2 = null;
            this.m_homePageTextField.getDocument().addDocumentListener(this);
            this.m_descriptionTextArea.getDocument().addDocumentListener(this);
            this.m_bIsModified = false;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_homePageTextField.getDocument().addDocumentListener(this);
            this.m_descriptionTextArea.getDocument().addDocumentListener(this);
            this.m_bIsModified = false;
            throw throwable;
        }
    }

    protected void refreshWorkBasketTable() {
        if (this.m_workBasketsTableModel.isModified()) {
            this.m_bIsModified = true;
        }
        this.m_workBasketsTableModel.reinitialize(this.m_dataDictionary);
    }

    public boolean isModified() {
        if (this.m_workBasketsTableModel != null && this.m_workBasketsTableModel.isModified()) {
            return true;
        }
        if (this.m_attributesPanel != null && this.m_attributesPanel.isModified()) {
            return true;
        }
        return this.m_bIsModified;
    }

    protected void resetModifiedFlag() {
        if (this.m_workBasketsTableModel != null) {
            this.m_workBasketsTableModel.resetModifiedFlag();
        }
        if (this.m_attributesPanel != null) {
            this.m_attributesPanel.resetModifiedFlag();
        }
        this.m_bIsModified = false;
    }

    protected void stopEditing() {
        if (this.m_workBasketsTable != null) {
            this.m_workBasketsTable.stopEditing();
        }
        if (this.m_attributesPanel != null) {
            this.m_attributesPanel.stopEditing();
        }
    }

    protected String[] getModifiedQueueNames() {
        if (this.m_modifiedQueueNames != null && !this.m_modifiedQueueNames.isEmpty()) {
            return this.m_modifiedQueueNames.toArray(new String[0]);
        }
        return null;
    }

    protected void releaseResources() {
        this.m_roleNameLabel = null;
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton = null;
        }
        if (this.m_descriptionTextArea != null) {
            this.m_descriptionTextArea.getDocument().removeDocumentListener(this);
            this.m_descriptionTextArea.removeAll();
            this.m_descriptionTextArea = null;
        }
        if (this.m_homePageTextField != null) {
            this.m_homePageTextField.getDocument().removeDocumentListener(this);
            this.m_homePageTextField = null;
        }
        if (this.m_previewButton != null) {
            this.m_previewButton.removeActionListener(this);
            this.m_previewButton = null;
        }
        if (this.m_workBasketsTable != null) {
            this.m_workBasketsTable.removeAll();
            this.m_workBasketsTable = null;
        }
        if (this.m_workBasketsTableModel != null) {
            this.m_workBasketsTableModel.releaseResources();
            this.m_workBasketsTableModel = null;
        }
        if (this.m_inbasketsToolBar != null) {
            this.m_inbasketsToolBar.releaseResources();
            this.m_inbasketsToolBar = null;
        }
        if (this.m_membersToolBar != null) {
            this.m_membersToolBar.releaseResources();
            this.m_membersToolBar = null;
        }
        if (this.m_membersList != null) {
            this.m_membersList.removeAll();
            this.m_membersList = null;
        }
        if (this.m_membersListModel != null) {
            this.m_membersListModel.removeAllElements();
            this.m_membersListModel = null;
        }
        if (this.m_attributesPanel != null) {
            this.m_attributesPanel.releaseResources();
            this.m_attributesPanel = null;
        }
        this.m_usersAndGroupsDialog = null;
        this.m_sessionInfo = null;
        this.m_roleDef = null;
        this.removeAll();
    }

    private void createControls() {
        try {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(10, 10, 5, 10);
            gbCons.gridheight = 1;
            gbCons.gridwidth = -1;
            this.m_roleNameLabel = new JLabel(VWResource.NoRoleSelected);
            VWAccessibilityHelper.setAccessibility(this.m_roleNameLabel, this, VWResource.Name, VWResource.Name);
            this.add((Component)this.m_roleNameLabel, gbCons);
            gbCons.anchor = 22;
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.gridwidth = 0;
            this.m_helpButton = (JButton)VWImageLoader.createToolBarButton("help20.gif", VWResource.Help, false);
            this.m_helpButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, this, VWResource.Help, VWResource.Help);
            this.m_helpButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_helpButton.getAccessibleContext().setAccessibleName(VWResource.Help);
            this.m_helpButton.addFocusListener(new VWToolbarButtonFocusAdapter(this.m_helpButton));
            this.m_helpButton.setRolloverEnabled(true);
            this.m_helpButton.setFocusable(true);
            this.m_helpButton.setBorderPainted(false);
            this.add((Component)this.m_helpButton, gbCons);
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.1;
            JPanel subPanel = new JPanel(new GridLayout(1, 2, 15, 15));
            subPanel.add(this.getDescriptionPanel());
            subPanel.add(this.getHomePagePanel());
            this.add((Component)subPanel, gbCons);
            ++gbCons.gridy;
            gbCons.weighty = 0.9;
            JTabbedPane tabbedPane = new JTabbedPane();
            subPanel = new JPanel(new GridLayout(1, 2, 15, 15));
            subPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 7, 10));
            subPanel.add(this.getWorkBasketsPanel());
            subPanel.add(this.getMembersPanel());
            tabbedPane.add(VWResource.SelectInbasketsAndMembers, subPanel);
            this.m_attributesPanel = new VWRoleAttributesPanel(this.m_sessionInfo);
            this.m_attributesPanel.getAccessibleContext().setAccessibleParent(tabbedPane);
            VWAccessibilityHelper.setAccessibility(this.m_attributesPanel, tabbedPane, this.m_attributesPanel.getTitle(), this.m_attributesPanel.getTitle());
            this.m_attributesPanel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            tabbedPane.add(this.m_attributesPanel.getTitle(), this.m_attributesPanel);
            this.add((Component)tabbedPane, gbCons);
            ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
            this.applyComponentOrientation(compOrientation);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getDescriptionPanel() {
        try {
            JPanel descriptionPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 21;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(3, 3, 3, 3);
            gbCons.gridheight = 1;
            gbCons.gridwidth = 0;
            VWInfoLabel descriptionLabel = new VWInfoLabel(VWResource.Description);
            descriptionLabel.updateFontSize("10");
            VWAccessibilityHelper.setAccessibility(descriptionLabel, this, VWResource.Description, VWResource.Description);
            descriptionPanel.add((Component)descriptionLabel, gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weighty = 1.0;
            this.m_descriptionTextArea = new JTextArea();
            this.m_descriptionTextArea.setLineWrap(true);
            this.m_descriptionTextArea.setWrapStyleWord(true);
            this.m_descriptionTextArea.setRows(5);
            this.m_descriptionTextArea.getDocument().addDocumentListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_descriptionTextArea, this, VWResource.Description, VWResource.Description);
            VWAccessibilityHelper.setLabelFor(new JLabel(VWResource.Description), this.m_descriptionTextArea);
            descriptionPanel.add((Component)new JScrollPane(this.m_descriptionTextArea), gbCons);
            return descriptionPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getHomePagePanel() {
        try {
            JPanel homePagePanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 21;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(3, 3, 3, 3);
            gbCons.gridheight = 1;
            gbCons.gridwidth = 0;
            VWInfoLabel homePageLabel = new VWInfoLabel(VWResource.EndUserHomePage, VWResource.EndUserHomePageDescription);
            homePageLabel.updateFontSize("10");
            VWAccessibilityHelper.setAccessibility(homePageLabel, this, VWResource.EndUserHomePage, VWResource.EndUserHomePage);
            homePagePanel.add((Component)homePageLabel, gbCons);
            ++gbCons.gridy;
            gbCons.gridwidth = 1;
            this.m_homePageTextField = new JTextField();
            this.m_homePageTextField.getDocument().addDocumentListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_homePageTextField, this, VWResource.EndUserHomePage, VWResource.EndUserHomePage);
            VWAccessibilityHelper.setLabelFor(homePageLabel, this.m_homePageTextField);
            homePagePanel.add((Component)this.m_homePageTextField, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.gridwidth = 0;
            this.m_previewButton = new JButton(VWResource.Preview);
            this.m_previewButton.setToolTipText(VWResource.PreviewEndUserHomePageButtonDescription);
            this.m_previewButton.addActionListener(this);
            this.m_previewButton.setMargin(new Insets(0, 5, 0, 5));
            this.m_previewButton.setEnabled(false);
            VWAccessibilityHelper.setAccessibility(this.m_previewButton, this, VWResource.Preview, VWResource.Preview);
            VWAccessibilityHelper.setLabelFor(homePageLabel, this.m_previewButton);
            homePagePanel.add((Component)this.m_previewButton, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            homePagePanel.add((Component)new JLabel(" "), gbCons);
            return homePagePanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getWorkBasketsPanel() {
        try {
            this.m_inbasketsToolBar = new VWToolbarBorder(VWResource.SelectInbasketsForRole, 268435491, VWResource.RoleInBasketsListDescription);
            this.m_inbasketsToolBar.setToolbarBackground(this.getBackground());
            this.m_inbasketsToolBar.addToolbarBorderActionNotifier(this);
            VWAccessibilityHelper.setAccessibility(this.m_inbasketsToolBar, this, VWResource.SelectInbasketsForRole, VWResource.SelectInbasketsForRole);
            JPanel workBasketPanel = this.m_inbasketsToolBar.getClientPanel();
            workBasketPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 21;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(0, 0, 5, 0);
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            gbCons.insets = new Insets(0, 0, 0, 0);
            gbCons.gridheight = 1;
            gbCons.gridwidth = 0;
            this.m_workBasketsTableModel = new VWWorkBasketsTableModel(this.m_dataDictionary);
            this.m_workBasketsTableModel.addTableModelListener(this);
            this.m_workBasketsTable = new VWTable(this.m_workBasketsTableModel);
            this.m_workBasketsTable.setRowSelectionAllowed(true);
            this.m_workBasketsTable.setShowGrid(false);
            this.m_workBasketsTable.setTableHeader(null);
            this.m_workBasketsTable.setRowHeight(26);
            this.m_workBasketsTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_workBasketsTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            ListSelectionModel lm = this.m_workBasketsTable.getSelectionModel();
            lm.setSelectionMode(0);
            lm.addListSelectionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_workBasketsTable, this, VWResource.InbasketsTable, VWResource.InbasketsTable);
            VWAccessibilityHelper.setLabelFor(new JLabel(VWResource.Inbaskets), this.m_workBasketsTable);
            TableColumn tcElement = this.m_workBasketsTable.getColumnModel().getColumn(0);
            if (tcElement != null) {
                tcElement.setCellRenderer(new VWInbasketListCellRenderer());
            }
            workBasketPanel.add((Component)new JScrollPane(this.m_workBasketsTable), gbCons);
            return this.m_inbasketsToolBar;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getMembersPanel() {
        try {
            this.m_membersToolBar = new VWToolbarBorder(VWResource.SelectMembersForRole, 0x10000020, VWResource.RoleMembersListDescription);
            this.m_membersToolBar.setToolbarBackground(this.getBackground());
            this.m_membersToolBar.addToolbarBorderActionNotifier(this);
            VWAccessibilityHelper.setAccessibility(this.m_membersToolBar, this, VWResource.SelectMembersForRole, VWResource.SelectMembersForRole);
            JPanel childPanel = this.m_membersToolBar.getClientPanel();
            childPanel.setLayout(new BorderLayout());
            this.m_membersListModel = new VWSortedListModel();
            this.m_membersList = new JList(this.m_membersListModel);
            this.m_membersList.setCellRenderer(new VWDesignerParticipantListCellRenderer());
            this.m_membersList.addListSelectionListener(this);
            this.m_membersList.setFixedCellHeight(26);
            VWAccessibilityHelper.setAccessibility(this.m_membersList, this, VWResource.RoleMembersList, VWResource.RoleMembersList);
            VWAccessibilityHelper.setLabelFor(new JLabel(VWResource.SelectMembersForRole), this.m_membersList);
            childPanel.add((Component)new JScrollPane(this.m_membersList), "Center");
            this.m_membersListModel.addListDataListener(this);
            return this.m_membersToolBar;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void initMembersList() {
        VWParticipant[] vwParticipants = null;
        VWParticipantItem[] vwParticipantItems = null;
        try {
            if (this.m_roleDef != null) {
                vwParticipants = this.m_roleDef.fetchRoleParticipants();
                vwParticipantItems = VWDefaultSessionProxy.getQuotedFullParticipantItems(vwParticipants, true);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            vwParticipantItems = VWDefaultSessionProxy.getParticipantItemsUsingParticipants(vwParticipants, true);
        }
        this.updateMembersList(vwParticipantItems);
    }

    private void updateMembersList(VWParticipantItem[] participantItems) {
        try {
            if (this.m_membersListModel == null) {
                return;
            }
            this.m_membersListModel.removeListDataListener(this);
            this.m_membersListModel.removeAllElements();
            if (participantItems != null && participantItems.length > 0) {
                for (int i = 0; i < participantItems.length; ++i) {
                    this.m_membersListModel.addElement(participantItems[i]);
                }
            }
            this.m_membersListModel.addListDataListener(this);
            this.updateMembersListButtonStates();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateMembersListButtonStates() {
        int nButtonState = 2;
        if (!this.m_membersListModel.isEmpty() && this.m_membersList.getSelectedIndex() != -1) {
            nButtonState = 1;
        }
        int nButtons = 0x10000000;
        this.m_membersToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_membersToolBar.getClientPanel(), nButtonState, nButtons));
    }

    private void updateInbasketListButtonStates() {
        int nButtonState = 2;
        int selectedRow = this.m_workBasketsTable.getSelectedRow();
        int rowCount = this.m_workBasketsTableModel.getRowCount();
        JPanel clientPanel = this.m_inbasketsToolBar.getClientPanel();
        if (rowCount > 0 && selectedRow != -1) {
            nButtonState = 1;
            int nButtons = 0x10000000;
            this.m_inbasketsToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, nButtonState, nButtons));
            nButtons = 1;
            nButtonState = selectedRow > 0 ? 1 : 2;
            this.m_inbasketsToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, nButtonState, nButtons));
            nButtons = 2;
            nButtonState = selectedRow < rowCount - 1 ? 1 : 2;
            this.m_inbasketsToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, nButtonState, nButtons));
        } else {
            this.m_inbasketsToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_inbasketsToolBar.getClientPanel(), 2, 0x10000003));
        }
    }

    private void modifyInbasketList() throws VWException {
        VWRoleSelectBasketsDialog rbDialog = new VWRoleSelectBasketsDialog(this.m_dataDictionary, this.m_roleDef);
        rbDialog.setVisible(true);
        if (rbDialog.getExitStatus() == 1 && rbDialog.isModified()) {
            this.m_roleDef.setWorkBasketDefinitions(rbDialog.getSelectedItems());
            String[] modifiedQueueNames = rbDialog.getModifiedQueueNames();
            if (modifiedQueueNames != null && modifiedQueueNames.length > 0) {
                this.updateModifiedQueueNames(modifiedQueueNames);
            }
            this.m_workBasketsTableModel.setRoleDefinition(this.m_roleDef);
            this.m_bIsModified = true;
        }
    }

    private void deleteSelectedInbaskets() {
        int nRowIndex = this.m_workBasketsTable.getSelectedRow();
        if (nRowIndex == -1) {
            return;
        }
        this.m_workBasketsTableModel.deleteInbasketAtIndex(nRowIndex);
        this.m_bIsModified = true;
        this.updateInbasketListButtonStates();
    }

    private void moveUpSelectedInbaskets() {
        int nRowIndex = this.m_workBasketsTable.getSelectedRow();
        if (nRowIndex <= 0) {
            return;
        }
        this.m_workBasketsTableModel.swap(nRowIndex, nRowIndex - 1);
        this.m_workBasketsTable.setRowSelectionInterval(nRowIndex - 1, nRowIndex - 1);
        this.m_bIsModified = true;
        this.updateInbasketListButtonStates();
    }

    private void moveDownSelectedInbaskets() {
        int nRowIndex = this.m_workBasketsTable.getSelectedRow();
        if (nRowIndex >= this.m_workBasketsTableModel.getRowCount() - 1) {
            return;
        }
        this.m_workBasketsTableModel.swap(nRowIndex, nRowIndex + 1);
        this.m_workBasketsTable.setRowSelectionInterval(nRowIndex + 1, nRowIndex + 1);
        this.m_bIsModified = true;
        this.updateInbasketListButtonStates();
    }

    private void modifyMembersList() {
        try {
            VWSession vwSession = this.m_sessionInfo.getSession();
            if (vwSession != null) {
                if (this.m_usersAndGroupsDialog == null) {
                    this.m_usersAndGroupsDialog = vwSession.getSecurityDatabaseType() == 1 ? new VWFilteredUsersAndGroupsDialog(this.m_sessionInfo.getParentFrame(), vwSession) : new VWUsersDialog(this.m_sessionInfo.getParentFrame(), vwSession);
                }
                Object[] objects = this.m_membersListModel.toArray();
                VWParticipantItem[] items = null;
                if (objects != null && objects.length > 0) {
                    items = new VWParticipantItem[objects.length];
                    System.arraycopy(objects, 0, items, 0, objects.length);
                }
                this.m_usersAndGroupsDialog.init(items, (String)null);
                this.m_usersAndGroupsDialog.setVisible(true);
                if (this.m_usersAndGroupsDialog.getStatus() == 1) {
                    VWParticipant[] vwParticipants = null;
                    VWParticipantItem[] participantItems = this.m_usersAndGroupsDialog.getParticipants();
                    if (participantItems != null && participantItems.length > 0) {
                        vwParticipants = VWDefaultSessionProxy.getParticipantsFromParticipantItems(participantItems, true);
                        participantItems = VWDefaultSessionProxy.getParticipantItemsUsingParticipants(vwParticipants, true);
                    }
                    this.m_roleDef.setRoleParticipants(vwParticipants);
                    this.updateMembersList(participantItems);
                    this.m_bIsModified = true;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    private void deleteSelectedMembers() {
        try {
            int[] selectedIndices = this.m_membersList.getSelectedIndices();
            if (selectedIndices != null && this.m_roleDef != null) {
                int nTotalSelectedCount = selectedIndices.length;
                int nParticipantListSize = this.m_membersListModel.getSize();
                for (int nIndex = nParticipantListSize - 1; nIndex >= 0; --nIndex) {
                    for (int selectedIndex = 0; selectedIndex < selectedIndices.length; ++selectedIndex) {
                        if (nIndex != selectedIndices[selectedIndex]) continue;
                        this.m_membersListModel.removeElementAt(selectedIndices[selectedIndex]);
                        if (--nTotalSelectedCount == 0) break;
                    }
                    if (nTotalSelectedCount == 0) break;
                }
                if (this.m_membersListModel.getSize() == 0) {
                    this.m_roleDef.setRoleParticipants(null);
                } else {
                    VWParticipant[] vwParticipants = new VWParticipant[this.m_membersListModel.getSize()];
                    for (int nIndex = 0; nIndex < this.m_membersListModel.getSize(); ++nIndex) {
                        VWParticipantItem pItem = (VWParticipantItem)this.m_membersListModel.getElementAt(nIndex);
                        vwParticipants[nIndex] = pItem.getVWParticipant();
                    }
                    this.m_roleDef.setRoleParticipants(vwParticipants);
                }
                this.m_bIsModified = true;
                this.updateMembersListButtonStates();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void handleUpdateEvent(Object source) {
        if (source == null || this.m_roleDef == null) {
            return;
        }
        if (source.equals(this.m_homePageTextField.getDocument())) {
            try {
                if (VWStringUtils.compare(this.m_roleDef.getHomePageURL(), this.m_homePageTextField.getText()) != 0) {
                    this.m_roleDef.setHomePageURL(this.m_homePageTextField.getText());
                    this.m_bIsModified = true;
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), ex.getLocalizedMessage(), 1);
                this.m_homePageTextField.selectAll();
            }
            this.updatePreviewButtonState();
        } else if (source.equals(this.m_descriptionTextArea.getDocument())) {
            try {
                if (VWStringUtils.compare(this.m_roleDef.getDescription(), this.m_descriptionTextArea.getText()) != 0) {
                    this.m_roleDef.setDescription(this.m_descriptionTextArea.getText());
                    this.m_bIsModified = true;
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), ex.getLocalizedMessage(), 1);
                this.m_descriptionTextArea.selectAll();
            }
        }
    }

    private void updatePreviewButtonState() {
        if (this.m_roleDef == null) {
            this.m_previewButton.setEnabled(false);
            return;
        }
        boolean bEnable = this.m_homePageTextField.getText() != null && this.m_homePageTextField.getText().length() > 0;
        this.m_previewButton.setEnabled(bEnable);
    }

    private void updateModifiedQueueNames(String[] modifiedQueueNames) {
        if (modifiedQueueNames != null && modifiedQueueNames.length > 0) {
            for (int i = 0; i < modifiedQueueNames.length; ++i) {
                String qName = modifiedQueueNames[i];
                if (this.m_modifiedQueueNames.contains(qName)) continue;
                this.m_modifiedQueueNames.add(qName);
            }
        }
    }
}

